#Importation du module nécessaire pour les fonctions de traitement d'image
import PIL.Image


#Fonctions à analyser : 

def conversion(code):
    '''
    fonction qui, à  partir d'un code binaire donné renvoie
    le nombre correspondant
    :: param : code : str
    :: return : int
    '''
    nombre = 0
    for symbole in code:
        nombre = 2*nombre + int(symbole)
    return nombre

def caractere(nombre):
    '''
    fonction qui renvoie le caractère de la table ASCII
    associé au nombre donné en paramètre
    :: param : nombre : int (compris entre 0 et 255)
    :: return : str
    '''
    assert 0<=nombre<=255, 'le nombre doit être entre 0 et 255'
    return chr(nombre)

def decode(ecriture_binaire,taille):
    '''
    fonction qui affiche la phrase codée en binaire par ecriture_binaire
    en associant une lettre à chaque bloc de taille bits
    :: param : ecriture_binaire : str composée de 0 et de 1
    :: param : taille : int (nombre de bits utilisés par symbole)
    :: return : str
    '''
    nbre_symb = len(ecriture_binaire) // taille
    phrase = ''
    i = 0
    for k in range(nbre_symb):
        nbre_binaire = ecriture_binaire[i:i+taille]
        nbre_decimal = conversion(nbre_binaire)
        phrase = phrase + caractere(nbre_decimal)
        i = i + taille
    print(phrase)

def afficher_image(source):
    '''
    fonction qui affiche l'image donnée en fichier source
    :: param : source : str (nom du fichier)
    '''
    image = PIL.Image.open(source)
    image.show()

def lire_image(source):
    '''
    fonction qui renvoie la liste composée des bits de poids faible
    de la couleur rouge sur la première ligne à partir du fichier
    image source
    :: param : source : str (nom de l'image)
    :: return : str (composée de 0 et de 1)
    '''
    image = PIL.Image.open(source)
    largeur, hauteur = image.size
    code = ''
    for x in range(largeur):
        r,v,b = image.getpixel((x,0))
        bit = str(r%2)
        code = code + bit
    return code