#!/usr/bin/python3

from Sens import Sens
from Situation import Situation
class Voiture:
    """
    :ivar int x: La position en abscisse
    :ivar int y: La position en ordonnée
    :ivar str lettre: La lettre qui identifie la voiture
    :ivar Sens sens: Le sens de la voiture : horizontale ou verticale
    :ivar Taille taille: La taille de la voiture : deux ou trois
    :ivar list case: La liste des cases de la grille occupées par la voiture
    """

    def __init__(self, x,y, lettre, sens, taille):
        """Constructeur de la classe.

        :param int x: La position en abscisse
        :param int y: La position en ordonnée
        :param str lettre: La lettre qui identifie la voiture
        :param Sens sens: Le sens de la voiture : horizontale ou verticale
        :param Taille taille: La taille de la voiture : deux ou trois

        >>> from Sens import Sens
        >>> from Taille import Taille
        >>> voiture = Voiture(2,2,"A",Sens.VERTICAL,Taille.DEUX)
        """
        self.x = x
        self.y = y
        self.lettre = lettre
        self.sens = sens
        self.taille = taille
        self.case = self.generer_cases_utilises()


    def __eq__(self, voiture):
        """
        Indique l'égalité ou non entre 2 voitures.

        On condisère que 2 voitures sont identiques si :

        * leur lettre sont identiques
        * leurs positions sont identiques
        * leur taille sont identiques

        La méthode retourne donc :

        * ``True`` :  Les deux voitures sont identiques
        * ``False`` : Les deux situations sont différentes

        :param Situation a: Une voiture
        :rtype: ``boolean``

        >>> from Sens import Sens
        >>> from Taille import Taille
        >>>
        >>> voiture_un = Voiture(2,2,"A",Sens.VERTICAL,Taille.DEUX)
        >>> voiture_deux = Voiture(2,2,"A",Sens.VERTICAL,Taille.DEUX)
        >>> voiture_trois = Voiture(2,2,"C",Sens.VERTICAL,Taille.DEUX)
        >>>
        >>> voiture_un == voiture_deux
        True
        >>> voiture_un == voiture_trois
        False
        """
        return self.x == voiture.x \
           and self.y == voiture.y \
           and self.lettre == voiture.lettre \
           and self.taille == voiture.taille

    def generer_cases_utilises(self):
        """Génère la liste des cases utilisées par la voiture.

        Une voiture avec une taille de 2 générera une liste de 2 cases.

        Une voiture avec une taille de 3 générera une liste de 3 cases.

        Cette méthode est appelée par le constructeur pour initialiser l'attribut *case*.

        :rtype: ``list(tuple())``

        >>> from Sens import Sens
        >>> from Taille import Taille
        >>>
        >>> voiture = Voiture(2,2,"A",Sens.VERTICAL,Taille.DEUX)
        >>> voiture.case
        [(2, 2), (2, 3)]
        """
        l = list()
        if self.sens is Sens.VERTICAL:
            for t in range(0, self.taille.value):
                l.append((self.x,self.y+t))
        else:
            for t in range(0, self.taille.value):
                l.append((self.x+t,self.y))
        return l

    def __str__(self):
        """Génère une chaine de charactères indiquant la lettre de la voiture.

        >>> from Sens import Sens
        >>> from Taille import Taille
        >>>
        >>> voiture = Voiture(2,2,"A",Sens.VERTICAL,Taille.DEUX)
        >>> print(voiture)
        [A]
        """
        return "["+self.lettre+"]"

    def info(self):
        """Retourne les informations d'une voiture :

        * La lettre
        * La position
        * Le sens
        * La taille
        * Les cases utilisées

        :rtype: ``dictionnary``

        >>> from Sens import Sens
        >>> from Taille import Taille
        >>>
        >>> voiture = Voiture(2,2,"A",Sens.VERTICAL,Taille.DEUX)
        >>> voiture = Voiture(2,2,"A",Sens.VERTICAL,Taille.DEUX)
        >>> voiture.info()
        {'lettre': 'A', 'position': (2, 2), 'sens': <Sens.VERTICAL: 2>, 'taille': <Taille.DEUX: 2>, 'case': [(2, 2), (2, 3)]}
        """
        return {"lettre":self.lettre,
                "position":(self.x,self.y),
                "sens":self.sens,
                "taille":self.taille,
                "case":self.case}


    def move(self, direction, situation):
        """Effectue le déplacement d'une voiture et retourne la nouvelle situation après déplacement.

        :param Direction direction: La direction dans laquelle il faut bouger la voiture
        :param type situation: La situation de jeu d'origine
        :rtype: ``Situation``

        >>> from Sens import Sens
        >>> from Taille import Taille
        >>> from Situation import Situation
        >>> from Direction import Direction
        >>>
        >>> # Création d'une voiture
        >>> voiture = Voiture(2,2,"X",Sens.HORIZONTAL,Taille.DEUX)
        >>>
        >>> #Création d'une situation
        >>> situation = Situation([voiture])
        >>> situation.afficher()
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][X][X][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        >>>
        >>> #Génération de la nouvelle situation
        >>> nouvelle_situation = voiture.move(Direction.DROITE, situation)
        >>> nouvelle_situation.afficher()
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][X][X][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        """
        #Attention problème de mutabilité des la liste des voiture
        # On créer une nouvelle situaton avec une nouvelle liste de voiture
        #Sinon les adresse son les meme, on travail avec une liste de voiure différente à chaque fois
        new_liste_voiture = situation.liste_voiture.copy()

        for voiture in new_liste_voiture:
            if voiture.lettre == self.lettre:
                new_liste_voiture.remove(voiture)

        x = self.x + direction.value[0]
        y = self.y + direction.value[1]
        new_voiture = Voiture(x,y,self.lettre,self.sens, self.taille )
        new_voiture.case = new_voiture.generer_cases_utilises() #Il faut update la liste des case utilisé par les voiture

        new_liste_voiture.append(new_voiture)
        s = Situation(new_liste_voiture)
        s.parent = situation
        return s
