#!/usr/bin/python3

from enum import Enum

class Taille(Enum):
    """
    Enumération représentant les 2 tailles possibles d'une voiture.

    La valeur de chaque taille correspond au nombre entier.

    >>> taille = Taille.DEUX
    >>> taille.name
    'DEUX'
    >>> taille.value
    2
    >>> type(taille)
    <enum 'Taille'>
    >>> taille == Taille.DEUX
    True
    >>> taille == Taille.TROIS
    False
    """
    DEUX = 2 #:
    TROIS = 3 #:
