#!/usr/bin/python3

from enum import Enum,auto

class Sens(Enum):
    """
    Enumération représentant les 2 sens possibles d'une voiture.

    La valeur de chaque sens n'a pas d'importance.

    >>> sens = Sens.HORIZONTAL
    >>> sens.name
    'HORIZONTAL'
    >>> type(sens)
    <enum 'Sens'>
    >>> sens == Sens.HORIZONTAL
    True
    >>> sens == Sens.VERTICAL
    False
    """
    HORIZONTAL = auto() #:
    VERTICAL = auto() #:
