#!/usr/bin/python3

from Sens import Sens
class Mouvement:
    """
    :ivar Direction direction: La direction dans lequel le mouvement doit être effectué
    :ivar Voiture voiture: La voiture qui doit effetuer le déplacement
    """

    def __init__(self, voiture, direction):
        """Constructeur de la classe

        :param Direction direction: La direction dans lequel le mouvement doit être effectué
        :param Voiture voiture: La voiture qui doit effetuer le déplacement

        >>> from Voiture import Voiture
        >>> from Sens import Sens
        >>> from Taille import Taille
        >>> from Direction import Direction
        >>>
        >>> voiture = Voiture(0,0,"A", Sens.HORIZONTAL, Taille.DEUX)
        >>> mouvement = Mouvement(Direction.DROITE, voiture )
        """
        self.direction = direction
        self.voiture = voiture

    def info(self):
        """Retourne les informations du mouvement :

        * La lettre qui identifie la voiture
        * La direction

        :rtype: ``dictionnary``

        >>> from Voiture import Voiture
        >>> from Sens import Sens
        >>> from Taille import Taille
        >>> from Direction import Direction
        >>>
        >>> voiture = Voiture(0,0,"A", Sens.HORIZONTAL, Taille.DEUX)
        >>> mouvement = Mouvement(voiture, Direction.DROITE)
        >>> mouvement.info()
        {'voiture': 'A', 'direction': 'Direction.DROITE'}

        """
        return {"voiture":self.voiture.lettre,
                "direction":str(self.direction)}

    def execute(self, situation):
        """Retourne la nouvelle situation après déplacement de la voiture.

        :param Situation situation: La situation où la voiture se déplace
        :rtype: ``Situation``

        >>> from Voiture import Voiture
        >>> from Sens import Sens
        >>> from Taille import Taille
        >>> from Direction import Direction
        >>> from Situation import Situation
        >>>
        >>> voiture = Voiture(0,0,"A", Sens.HORIZONTAL, Taille.DEUX)
        >>> situation = Situation([voiture])
        >>> situation.afficher()
        [A][A][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        >>> mouvement = Mouvement(voiture, Direction.DROITE)
        >>> nouvelle_situation = mouvement.execute(situation)
        >>> nouvelle_situation.afficher()
        [ ][A][A][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
                """
        return self.voiture.move(self.direction, situation)

    def __eq__(self,mouvement):
        """
        Indique l'égalité ou non entre 2 mouvements.

        On condisère que 2 mouvements sont identiques si :

        * leur direction sont identiques
        * leurs voitures sont identiques

        La méthode retourne donc :

        * ``True`` :  Les deux mouvement sont identiques
        * ``False`` : Les deux mouvements sont différents

        :param Mouvement mouvement: Une mouvement
        :rtype: ``boolean``

        >>> from Voiture import Voiture
        >>> from Sens import Sens
        >>> from Taille import Taille
        >>> from Direction import Direction
        >>>
        >>> voiture = Voiture(0,0,"A", Sens.HORIZONTAL, Taille.DEUX)
        >>> mouvement1 = Mouvement(Direction.DROITE, voiture )
        >>> mouvement2 = Mouvement(Direction.GAUCHE,voiture)
        >>> mouvement3 = Mouvement(Direction.GAUCHE, voiture)
        >>> mouvement1 == mouvement2
        False
        >>> mouvement3 == mouvement2
        True
        """
        return self.direction == mouvement.direction and self.voiture ==mouvement.voiture
