#!/usr/bin/python3


class File:
    """
    :ivar list liste: Implémentation d'une file avec une liste
    """

    def __init__(self):
        """Constructeur de la classe

        >>> file = File()
        """
        self.liste = list()

    def est_vide(self):
        """Retourne ``True`` si la file est vide.

        :rtype: ``boolean``

        >>> file = File()
        >>> file.est_vide()
        True
        >>> file.enfiler(1)
        >>> file.est_vide()
        False
        """
        return len(self.liste)==0

    def longueur(self):
        """Retourne la longueur de la file.

        :rtype: ``int``

        >>> file = File()
        >>> file.longueur()
        0
        >>> file.enfiler(1)
        >>> file.longueur()
        1
        """
        return len(self.liste)

    def enfiler(self, data):
        """Ajouter un élément à la fin de la file.

        :param Object data: Un élement à ajouter

        >>> file = File()
        >>> file.longueur()
        0
        >>> file.enfiler("bonjour")
        >>> file.longueur()
        1
        """
        if data is not None:
            self.liste.append(data)

    def defiler(self):
        """Retourne l'élément en tête de file.

        :rtype: ``Object``
        
        >>> file = File()
        >>> file.longueur()
        0
        >>> file.enfiler("bonjour")
        >>> file.longueur()
        1
        >>> i = file.defiler()
        >>> i
        'bonjour'
        >>> file.est_vide()
        True
        >>> file.longueur()
        0
        """
        return self.liste.pop(0)


    def afficher(self):
        """Affiche le contenu de la file.

        >>> file = File()
        >>> file.enfiler("bonjour")
        >>> file.afficher()
        [  TOP   ]
        bonjour
        [  BOTOM ]
        """
        print("[  TOP   ]")
        for i in self.liste:
            print(i)
        print("[  BOTOM ]")
