#!/usr/bin/python3

from enum import Enum

class Direction(Enum):
    """
    Enumération représentant les 4 directions possibles pour un mouvement.

    La valeur de chaque direction est un tuple indiquant le déplacement en x et y à effectuer.

    >>> direction = Direction.HAUT
    >>> direction.name
    'HAUT'
    >>> direction.value
    (0, -1)
    >>> type(direction)
    <enum 'Direction'>
    >>> direction == Direction.HAUT
    True
    >>> direction == Direction.BAS
    False
    """
    HAUT =( 0,-1) #:
    BAS = (0,1) #:
    DROITE = (1,0) #:
    GAUCHE =(-1,0) #:
