#!/usr/bin/python3

class CaseVide():
    """
    :ivar int x: La position en abscisse
    :ivar in y: La position en ordonnée
    """

    def __init__(self,x, y):
        """Constructeur de la classe.

        :param int x: La position en abscisse
        :param type y: La position en ordonnée

        >>> c = CaseVide(3,3)
        """
        self.x = x
        self.y = y

    def __str__(self):
        """Génère une chaine de charactères représentant une case vide.

        >>> c = CaseVide(3,3)
        >>> print(c)
        [ ]

        """
        return "[ ]"

    def info(self):
        """Retourne les informations d'une case vide :

        * Position x
        * Position y

        :rtype: ``dictionnary``

        >>> c = CaseVide(3,3)
        >>> c.info()
        {'x': 3, 'y': 3}
        """
        return {"x":self.x,
                "y":self.y}

    def get_voisins(self, situation):
        """Retourne la liste des voisins d'une case vide.

        Un voisin peut être :

        * Une case d'une voiture
        * Une case vide
        * ``None`` si le voisin est hors de la grille

        L'ordre de la liste a une importance : [ HAUT, DROITE, BAS, GAUCHE]

        :param Situation situation: La situation courante
        :rtype: ``list()``

        >>> from Sens import Sens
        >>> from Taille import Taille
        >>> from Voiture import Voiture
        >>> from Situation import Situation
        >>>
        >>> a = Voiture(0,0,"A", Sens.HORIZONTAL, Taille.DEUX)
        >>> b = Voiture(4,4,"B", Sens.HORIZONTAL, Taille.DEUX)
        >>> c = Voiture(2,5,"C", Sens.HORIZONTAL,Taille.TROIS)
        >>> x = Voiture(1,2,"X",Sens.HORIZONTAL,Taille.DEUX)
        >>> situation = Situation([a,b,c,x])
        >>> situation.afficher()
        [A][A][ ][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][X][X][ ][ ][ ]
        [ ][ ][ ][ ][ ][ ]
        [ ][ ][ ][ ][B][B]
        [ ][ ][C][C][C][ ]
        >>> case_vide = situation.grille[1][1]
        >>> [str(v) for v in case_vide.get_voisins(situation) ]
        ['[A]', '[ ]', '[X]', '[ ]']
        """
        voisins = list()#dict()
        x =self.x
        y = self.y

        #VOISIN NORD
        if y-1 >= 0 :
            voisins.append(situation.grille[x][y-1])
        else:
            voisins.append(None)

        #VOISIN EST
        if x+1 <=5 :
            voisins.append(situation.grille[x+1][y])
        else:
            voisins.append(None)

        #VOISIN SUD
        if y+1 <=5 :
            voisins.append(situation.grille[x][y+1])
        else:
            voisins.append(None)

        #VOISIN OUEST
        if x-1 >= 0 :
            voisins.append(situation.grille[x-1][y])
        else:
            voisins.append(None)

        return voisins
