#!/usr/bin/python3

class Arbre:
    """
    :ivar Object data: La valeur du noeud
    :ivar list fils: La liste des noeuds fils
    :ivar Arbre parent: Le noeud parent
    """

    def __init__(self, data, fils):
        """Constructeur de la classe

        :param (Object) data: La valeur du noeud
        :param list fils: La liste des noeuds fils

        >>> fils_1 = Arbre("1",None)
        >>> fils_2 = Arbre("2",None)
        >>> arbre = Arbre("root",[fils_1,fils_2])
        """
        self.data = data
        if fils is None:
            self.fils = list()
        else:
            self.fils=fils
        self.parent= None

    def get_data(self):
        """Retourne la valeur du noeud de l'arbre.

        :rtype: ``Object``

        >>> fils_1 = Arbre("1",None)
        >>> fils_2 = Arbre("2",None)
        >>> arbre = Arbre("root",[fils_1,fils_2])
        >>> arbre.get_data()
        'root'
        """
        return self.data

    def get_fils(self):
        """Retourne la liste des fils de l'arbre.

        :rtype: ``list(Arbre)``

        >>> fils_1 = Arbre("1",None)
        >>> fils_2 = Arbre("2",None)
        >>> arbre = Arbre("root",[fils_1,fils_2])
        >>> [a.get_data() for a in arbre.get_fils()]
        ['1', '2']
        """
        return self.fils

    def add_fils(self, fils):
        """ **Ajoute** un fils à la liste et **retourne** ce fils sous fome d'arbre.

        :param Arbre fils: Un nouveau fils

        >>> fils_1 = Arbre("1",None)
        >>> fils_2 = Arbre("2",None)
        >>> arbre = Arbre("root",[fils_1,fils_2])
        >>> arbre.add_fils("3").get_data()
        '3'
        >>> len(arbre.get_fils())
        3
        """
        a = Arbre(fils , None)
        a.parent = self
        self.fils.append(a)
        return a
