
class Vehicle:

    DIRS = {"U": (-1, 0),
            "R": (0, 1),
            "D": (1, 0),
            "L": (0, -1)}

    ORIENTATION_DIRS = {"H": "LR", "V": "UD"}

    def __init__(self, name, length, orientation, pos=None):
        """
        create a vehicle with is name, length and orientation
        """
        assert type(name) == str
        assert type(length) == int and length in {2, 3}
        assert orientation in "HV"

        self.__name = name
        self.__length = length
        self.__orientation = orientation
        self.__pos = pos

    def orientation(self):
        """
        :return: vehicle's orientation
        """
        return self.__orientation

    def name(self):
        """
        :return: vehicle's name
        :rtype: str
        """
        return self.__name

    def __str__(self):
        """
        return string representation of vehicle
        """
        return self.name()

    __repr__ = __str__

    def __hash__(self):
        return hash(self.__name)

    def __len__(self):
        """
        :return: vehicle's length
        :rtype: int
        """
        return self.__length

    def setPos(self, p):
        """
        set vehicle position
        """
        self.__pos = p
        self.__p = self.__pos

    def pos(self):
        return self.__pos

    def move(self, d):
        """
        move vehicle in d direction
        """
        if d not in Vehicle.DIRS:
            raise Exception(f"{d} is not a valid direction")
        if self.__pos is None:
            raise Exception("position is not set")
        if d not in Vehicle.ORIENTATION_DIRS[self.__orientation]:
            raise Exception(f"{d} is not a valid direction for {self}")
        dx, dy = Vehicle.DIRS[d]
        self.__pos = (self.__pos[0] + dx, self.__pos[1] + dy)

    def __iter__(self):
        if self.__pos is None:
            raise Exception
        self.__n = 0
        self.__p = self.__pos
        return self

    def __next__(self):
        if self.__pos is None:
            raise Exception("position is not set")
        d = "R" if self.__orientation == "H" else "D"
        res = self.__p
        if self.__n < self.__length:
            dx, dy = Vehicle.DIRS[d]
            self.__p = (self.__p[0] + dx, self.__p[1] + dy)
            self.__n += 1
            return res
        else:
            raise StopIteration
