from queue import Queue
from rushhour import RushHour


class Solver:

    def __init__(self, rhgame):
        """
        :param rhgame: a valid RushHour Game
        :type rhgame: RushHour
        """
        self.__game = rhgame
        self.__queue = Queue()
        self.__queue.put((rhgame.toConf(), ""))
        self.__seen = set()
        self.__solutions = []

    def solve(self):
        """
        solve a RushHour game
        """
        solved = False
        while not self.__queue.empty() and not solved:
            conf, path = self.__queue.get()
            g = RushHour.fromConf(conf)
            for vname, moves in g.allMoves().items():
                for m in moves:
                    g = RushHour.fromConf(conf)
                    g.move(g.vehicle(vname), m)
                    new_conf = g.toConf()
                    if str(g) not in self.__seen:
                        self.__seen.add(str(g))
                        self.__queue.put((new_conf, path+vname+m))
                        if g.isFinal():
                            self.__solutions.append((new_conf, path+vname+m))
                            solved = True
        return len(self.__solutions) > 0

    def seen(self):
        return self.__seen

    def solution(self):
        return self.__solutions


def main():
    # a difficult one ....
    conf = ['A;0,1;H',
            'B;1,1;V',
            'C;1,2;V',
            'D;0,4;V',
            'X;2,3;H',
            'E;3,3;V',
            'F;5,0;H',
            'G;4,2;V',
            'I;5,3;H',
            'J;4,4;H',
            'O;0,0;V',
            'P;3,0;H',
            'Q;1,5;V']
    game = RushHour.fromConf(conf)
    print(game)
    s = Solver(game)
    if s.solve():
        moves = s.solution()[0][-1]
        print(f"solved game in {len(moves)} moves, moves are {moves}")
    else:
        print("game is not solvable")


if __name__ == '__main__':
    main()
