from copy import deepcopy
from queue import Queue

CARS_2 = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'X', 'Z'}
CARS_3 = {'O', 'P', 'Q', 'R'}
ALL_CARS = CARS_2 | CARS_3

# Problème 1 (pour les autres on peut prévoir une lecture de fichier pour générer config)
CONFIG_1=[{'car':'A', 'position':(0, 0), 'orientation':'H'},
          {'car':'B', 'position':(0, 2), 'orientation':'V'},
          {'car':'C', 'position':(0, 3), 'orientation':'V'},
          {'car':'D', 'position':(1, 0), 'orientation':'V'},
          {'car':'E', 'position':(1, 4), 'orientation':'H'},
          {'car':'Z', 'position':(2, 1), 'orientation':'H'},
          {'car':'F', 'position':(2, 3), 'orientation':'V'},
          {'car':'G', 'position':(2, 4), 'orientation':'V'},
          {'car':'H', 'position':(3, 0), 'orientation':'H'},
          {'car':'I', 'position':(3, 2), 'orientation':'V'},
          {'car':'J', 'position':(4, 3), 'orientation':'H'},
          {'car':'K', 'position':(4, 5), 'orientation':'V'},
          {'car':'X', 'position':(5, 0), 'orientation':'H'},
          {'car':'O', 'position':(5, 2), 'orientation':'H'}]


# dimension d'une voiture
def car_length(c: str)->int:
    if (c in ALL_CARS):
        return 2 if c in CARS_2 else 3


# création plateau vide
def empty_board():
    return [[None for _ in range(6)] for _ in range(6)]


# remplissage d'un plateau en fonction d'une config
def fill_board(config: list)-> list:
    board = empty_board()
    for c in config:
        x = c['position'][0]
        y = c['position'][1]
        o = c['orientation']
        board[x][y] = c['car']
        if car_length(c['car']) >= 2 and o == 'H':
            board[x][y+1] = c['car']
        if car_length(c['car']) >= 2 and o == 'V':
            board[x+1][y] = c['car']
        if car_length(c['car']) == 3 and o == 'H':
            board[x][y+2] = c['car']
        if car_length(c['car']) == 3 and o == 'V':
            board[x+2][y] = c['car']
    return board


# vue du plateau
def view_board(board: list) -> str:
    s = ""
    for l in range(len(board)):
        for c in range(len(board[0])):
            if board[l][c] == None:
                s += ' '
            else:
                s += board[l][c]
        s += '\n'
    print(s)


# liste de tous les mouvements possibles pour une configuration
def all_moves(config: list) -> list:
    moves=[]
    board = fill_board(config)
    for c in config:
        x = c['position'][0]
        y = c['position'][1]
        o = c['orientation'] # orientation voiture
        long = car_length(c['car']) # longueur voiture
        if o == "H":
            dy = 1
            new_leftBound = y - dy
            while new_leftBound >= 0 and board[x][new_leftBound] == None:
                moves.append(c['car']+'L'+ str(dy))
                dy += 1
                new_leftBound = y - dy
            dy = 1
            new_rightBound = y + dy + long - 1
            while new_rightBound <= (len(board[0])-1) and board[x][new_rightBound] == None:
                moves.append(c['car']+'R'+ str(dy))
                dy += 1
                new_rightBound = y + dy + long - 1
                
        elif o == "V":
            dx = 1
            new_uppBound = x - dx
            while new_uppBound >= 0 and board[new_uppBound][y] == None:
                moves.append(c['car']+'U'+ str(dx))
                dx += 1
                new_uppBound = x -dx
            dx = 1
            new_downBound = x + dx + long - 1
            while new_downBound <= (len(board) - 1)  and board[new_downBound][y] == None:
                moves.append(c['car']+'D'+ str(dx))
                dx += 1
                new_downBound = x + dx + long - 1
    return moves


# prochaine configuration fournie à partir d'un mouvement
def next_config(config:list, move : str)-> list:
    name, direction, deplacement = tuple(move)
    if direction =="U" or direction =="L":
        deplacement = -int(deplacement)
    next_config = deepcopy(config)
    for i in range(len(next_config)):
        if next_config[i]['car'] == name :
            x, y  = next_config[i]['position']
            if direction =="U" or direction =="D":
                next_config[i]['position'] = (x + int(deplacement), y)
            if direction =="L" or direction =="R":
                next_config[i]['position'] = (x, y  + int(deplacement))
    return next_config


# Détermine si une configuration est finale
def is_final(config : list)-> bool:
    for i in range(len(config)):
         if config[i]['car'] == 'Z' :
             return config[i]['position'][1] == 5


if __name__ == "__main__":
    """
    first_board = fill_board(CONFIG_1)
    print("plateau initial")
    view_board(first_board)
    print("mouvements possibles à partir du plateau initial")
    moves_step1 = all_moves(CONFIG_1)
    print(moves_step1)
    print("plateaux suivants")
    for m in moves_step1:
        config = next_config(CONFIG_1, m)
        new_board = fill_board(config)
        view_board(new_board)
        print("position finale ?", is_final(config))
    moves_step2 = all_moves(config)
    print(moves_step2)
    """
    config = CONFIG_1
    first_board = fill_board(config)
    print("plateau initial")
    view_board(first_board)
    # A modifier : chaque élément de la  file doit être une confi et une liste de mouvement qui y conduit
    a_traiter = Queue() # file de configuration à examiner
    a_traiter.put(config)
    traites = [] # consfiguration déjà examinées
    while not is_final(config) or a_traiter.empty():
        config = a_traiter.get()
        moves = all_moves(config)
        for move in moves :
            new_config = next_config(config, move)
            if new_config not in traites: # A modifier créer fonction pour tester si config identiques !!
                a_traiter.put(new_config)
        final_board = fill_board(config)
        view_board(final_board)