# But du projet

Écrire une activité élève permettant :
- l'implémentation du "Jeu de la Vie" ;
- l'étude de l'évolution d'une population de cellules ;
- le détournement de son utilisation première pour des animations.

___
# Présentation de cet automate cellulaire

Le "jeu de la vie" est un **automate cellulaire** : ensemble de cellules, représenté dans une grille, qui peut évoluer au cours du temps.

![photo_conway](images/conway.png)

En réponse à un problème de John von Neumann qui recherchait une machine capable d'auto-réplication, [John Horton Conway](https://fr.wikipedia.org/wiki/John_Horton_Conway), en 1970, a construit ce modèle mathématique basé sur un algorithme avec des règles basiques.

Aujourd'hui, les automates cellulaires, comme le "jeu de la vie", sont utilisés dans des simulations informatiques : évolution des cellules vivantes dans un organisme, évolution de certaines populations...

___
# Règles de vie d'une cellule
Dans le cadre du projet, on utilisera les règles fixées à l'origine par J.H. Conway :

- l'espace de simulation sera une grille suffisamment grande (16 x 16  minimum)
- chaque case peut contenir au plus une cellule (0 ou 1 cellule)
- l'automate cellulaire évolue dans le temps par succession de générations.

Les cellules naissent, survivent ou meurent en fonction de leur voisinage, à chaque génération :

**Une cellule naît dans une case qui possède exactement 3 cellules voisines.**

![regle1](images/regle1.png)

**Une cellule meurt si elle est isolée (sous-population) :  < 2 cellules voisines.**

![regle2](images/regle2.png)

**Une cellule meurt si elle est entourée de plus de trois cellules (sur-population).**

![regle3](images/regle3.png)

**Une cellule survie donc que lorsqu'elle a 2 ou 3 cellules voisines (stabilité).**

___
# Exemples de motifs utilisables pour les animations

|||
|:-:|:-:|
|Un oscillateur "crapeau"|Un oscillateur "galaxie"|
|![crapeau](images/crapeau.png)|![galaxie](images/galaxie.png)|
|Un "planeur"|Un "canon à planeurs"|
|![planeur](images/planeur.png)|![canon](images/canon.png)|


*[Aide à la réalisation :](src/readme.md)*
- *conception d'un motif : `creation_map.py`*
- *interface graphique : `affichage_grille.py`*