# Projet évalué : Dessine ta rue

## 1 - Objectifs

### 1.1 - Notions du programmes traités par le projet

Identifier les points du programmes traités par le projet.

+ **modularité**
+ **structures de données** : selon les choix effectués par l'enseignant ou les élèves si libre (dictionnaires, listes, objets)
+ **programme en tant que donnée**
+ **interface**
+ gestion des **fichiers**
+ **résolution de problèmes** par la résolution de sous-problèmes
+ **bonnes pratiques de programmation**


### 1.2 - Autres objectifs

Quels autres objectifs poursuit ce projet ?

+ encapsulation et communication entre les modules : on peut arriver facilement à faire comprendre l'intérêt des mutateurs et des accesseurs, surtout si on part sur une version d'un module pouvant discuter avec plusieurs autres modules en entrée ou en sortie.
+ création de packages et de bibliothèques de modules.
+ pour les meilleurs, on peut envisager une vraie analyse lexicale puis une analyse syntaxique.
+ plus tard, une fois les arbres abordés, on pourrait reprendre une partie de l'analyse et voir comment représenter tout cela sous forme d'arbre (pas binaire malheureusement).
+ les expressions régulières pour l'analyse de texte simplifieraient beaucoup les choses...

+ **repartition des tâches** : plusieurs fichiers à traiter, plusieurs tâches par fichier et plusieurs degrés de difficultés.
+ **respect des consignes** données et des critères imposés.
+ **communication** et **planification** : il est nécessaire pour gagner du temps qu'ils créent les prototypes des fonctions de façon à pouvoir gagner du temps. Mais pour cela, il faut vraiment ici (à cause de l'interfaçage) qu'ils se mettent d'accord au préalable)
+ **documentation** : le nombre de structures de données, de clés de dictionnaire ou autres devient vite un problème, s'ils ne pensent pas centraliser les choses. Cela permettra de rendre l'introduction de programmation orientée objet d'autant plus pertinente quelques semaines plus tard.
+ **séparation nette** dans les modules fournis, des **fonctions d'interface** et des fonctions internes au module.

+ **importance de la réflexion préliminaire** : sur ce projet, le moindre petit rajout peut éventuellement créer des problèmes. Une bonne réflexion préliminaire en vue de bien stocker toutes les informations nécessaires est réellement importante.

+ **recherche d'informations** : il est fort probable que les élèves vont désirer faire quelque chose non vue avec l'interface graphique. Ils devront alors se renseigner par eux-même.


## 2 - Positionnement du projet

### 2.1 - dessine ta rue dans la progression

+ **Niveau terminale** : il nécessite juste d'avoir aborder le cours sur les modules de façon à ce qu'ils sachent les réaliser.
+ **Début de terminale** : ce projet se situe concrètement en début de terminale : après 2 mois de vacances, il permet de se réapproprier les bases de la programmation (fonctions, boucles, instructions conditionnelles, dictionnaire). Ce projet projet qui arrive rapidement permet également de former des groupes rapidement, plutôt que d'attendre plusieurs semaines.

+ **Progression personnelle** : dans le cadre de ma propre progression, les élèves ont déjà vu le squelette du module **formes** et l'ont déjà importé pour dessiner à partir d'un autre autre programme.

+ **Que faire en parallèle du projet ?** : on peut aborder en parallèle sur la récursivité ou le début des structures de données listes, pile, file.

+ Si la programmation orienté objet a déjà été abordée, une grande partie des élèves partira dans cette direction.

+ **En fin de première ?** : on pourrait envisager ce projet en fin de première, peut-être en n'insérant pas l'interpréteur.

### 2.2 - Pré-requis

+ **Niveau de base** : Lecture d'un fichier-texte.
+ **Niveau de base à correct** : utilisation de module en Python (on peut corser les choses via les bibliothèques ou la gestion de plusieurs thèmes de dessin par exemple)
+ **Niveau correct** : la programmation de base  (fonction, boucle, instruction conditionnelle...)
+ **Niveau correct** : les structures de données. Le transfert d'informations d'un module à l'autre rend leur utilisation plus délicate.
+ **Niveau correct** : gestion des strings, en passant ou pas par des tableaux de façon intermédiaire.


### 2.3 Modalités du projet

#### acquis confortés

+ les notions de **résolution de problèmes** en résolution de sous-problèmes et d'appels de fonctions dédiées.

+ **Réactivation des bases de programmation** après 2 mois de vacances.


#### nouvelles notions abordées

+ Mise en **pratique progressive de la modularité** : un module qui utilise un module, qui lui-même utilise un autre module...

+ **Notion de syntaxe** par l'exemple, en les forçant à réaliser leur propre "langage".

+ **Encapsulation** et la centralisation des informations devraient permettre de donner du sens à la programmation orientée objet et leur permettre de faire le lien entre plusieurs autres leçons.


### 2.4 Développements à la suite du projet

+ On peut en reparler lors de la présentation des **objets**.

+ On peut reparler de la partie **interpreteur** lors de la partie __Programme en tant que données__ ou lors de la partie sur les arbres.

+ On peut parler de la représentation dans l'autre sens : l'enregistrement de la rue. Quelles informations stocker ?





## 3 Guidé / pas guidé ?

### le matériel

Que fournit-on si on envisage de donner ce projet ...

+ des visuels des affichages voulus
+ des liens vers la documentation de l'interface graphique utilisée.

#### ... sans guider les élèves ?

+ au moins les consignes sur les dimensions à respecter : cela évite de perdre du temps sur des détails.
+ au moins les noms des 3 fichiers : ça évitera à l'enseignant de se demander comment tout s'organise.


#### ... si on veut guider les élèves ?

+ au moins l'un des scripts. Le plus évident est bien entendu **formes** car celui-ci contient surtout de la manipulation directe de Turtle.
+ si on donne le début de **rue**, on peut également gagner beaucoup de temps mais les élèves sont bien mieux confrontés à la difficulté de la compréhension de l'interfaçage.

### pourquoi fournir ce projet ....

#### ... sans guider les élèves ?

+ Les élèves réalisent l'interfaçage eux-même et la notion sera certainement bien ancrée.
+ De la même façon, si certains ne réalisent pas une vraie encapsulation entre les différentes parties, on pourra intervenir pour leur faire modifier leur organisation de communication.


#### ... en guidant les élèves ?

+ Le guidage permet d'éviter certains interfaçages ne respectant pas vraiment l'encapsulation. En fournissant un premier jet propre, on obtiendra plus de projets corrects à la fin (au risque qu'ils soient propres "par hasard" et pas parce que les élèves ont vraiment compris la notion)
+ En fournissant des squelettes ou des indications claires de ce qu'on veut, il est plus facile de leur faire utiliser telle ou telle structure de données. Dans la version guidée proposée, on utilise ainsi beaucoup les dictionnaires et les élèves auront donc tous quelques heures de révisions effectives sur cette structure.


## 4 L'évaluation

### liste des attendus, critères d'évaluation

Quels sont les critères d'évaluation ? Précisez ceux que l'on donne aux élèves.

4 critères de réussite sur 5 par exemple.

On attribue **une note de 0 à 5** aux critères.

+ 5 si Bien
+ 4 si Assez bien
+ 3 si Moyen
+ 2 si Léger
+ 1 si Insuffisant
+ 0 si Rien

On fait la **somme des critères**.

Attention : aucun critère ne peut avoir plus que (le plus petit + 2).

#### Critère 1 - Réalisation pratique du projet

+ Général : Toutes les fonctionnalités sont présentes
+ Général : Respect scrupuleux du cahier des charges
+ Spécifique à ce projet : Respect de l'encapsulation et de la modularité : les différentes parties du projet sont-elles réutilisables ?

#### Critère 2-  Bonnes pratiques de programmation

+ Noms explicites
+ Utilisation limitée et raisonnée des variables globales
+ Fonctions courtes et décomposition en sous-étapes
+ Séparation entre fonctions gérant les données et l'interface graphique.
+ Présence de jeux de tests pour les fonctions gérant les données

#### Critère 3 - Communication (à l'écrit et à l'oral)

+ Documentation des fonctions et des modules
+ Qualité de l'interaction avec l'enseignant
+ Qualité de l'interaction avec les autres membres de l'équipe

#### Critère 4 - Qualité de la revue de projet

+ régularité des informations notées
+ description de qui a fait quoi
+ prototypes des fonctions avant implémentation
+ tests permettant de valider la solution avant implémentation si possible, après coup sinon


## 5 - Temps nécessaire

### non guidé

+ 10 heures de travail au moins ?
+ 2h pour s'approprier et finaliser le module **formes**, le plus simple.
+ 4h pour le module **rue** au moins s'il est réalisé entièrement.
+ 4h pour le module **interpreteur** car il est plus que probable qu'il faudra modifier le module **rue** s'il n'a pas été conçu initialement en gérant la notion de fonctions d'interface.

+ Semi-guidé ? même sans guider les élèves en fournissant des squelettes de modules, on peut leur proposer une progression de résolution à suivre.

### guidé

+ 7 heures de travail au moins ?
+ 2h pour s'approprier et finaliser le module **formes**, le plus simple.
+ 3h pour s'approprier et finaliser le module **rue** au moins
+ 2h pour le module **interpreteur** si le module **rue** est bien conçu, potentiellement beaucoup plus sinon.

## 6 - Organisation de la répartition du travail

Comment avancer ? Voici ce qu'on peut proposer aux élèves.

Dans le module **formes**, commencer par **réaliser les prototypes des fonctions de formes de base** qui seront utiles dans le cadre futur de la fonction ```dessiner_immeuble()```.

Dans le module **rue**, on peut en parallèle commencer à :

+ réfléchir sur la structure de données permettant de stocker l'immeuble
+ créer une fonction pour déterminer aléatoirement le nombre d'étages ?
+ créer une fonction pour déterminer aléatoirement la couleur de la façade ?
+ créer une fonction pour tracer la façade en fonction du nombre d'étages, de la couleur de la façade et de sa position dans la rue ?
+ créer une fonction permettant de dessiner 4 immeubles sous forme d'une forme simple (rectange, triangle...) positionner en fonction du numéro de l'immeuble.
+ une fois le prototype réalisé, il suffira de rajouter les options à travers de nouvelles fonctions : une fonction pour tracer une porte ?  une fonction pour tracer une fenêtre ? une fonction pour tracer les fenêtres ? une fonction pour tracer le toit ? une fonction pour tracer une antenne ou un pigeon ?

Pour le module **interpreteur** :

+ il faut réfléchir à la façon dont on peut décrire un immeuble, pour savoir combien d'immeubles...
+ retrouver comment lire un fichier ligne par ligne, pour retrouver les informations contenues dans une chaîne de caractère...
