'''Module basé sur le module Turtle.
Il permet de dessiner des formes simples à l'aide de 5 fonctions suivantes :

Fonctions d'interface dessinant une forme
-----------------------------------------

+ rectangle(largeur:int, hauteur:int, infos:dict, coordonnees:tuple)      
+ triangle_isocele(cote:int, hauteur:int, infos:dict, coordonnees:tuple) 
+ triange_equilateral(cote:int, infos:dict, coordonnees:tuple)
+ cercle(rayon:int, infos:dict, coordonnees:tuple)
+ arc_de_cercle(rayon:int, angle:int, infos:dict, coordonnees:tuple)


Exemples d'utilisation
----------------------
>>> infos = {'écriture':'blue', 'fond':'#FF88FF', 'épaisseur':5}
>>> triangle_equilateral(50, infos, (50,100))
>>> cercle(75, infos, (200,-200))

'''

# Importation

import turtle as trt


# Déclaration des fonctions qui ne sont pas dans l'interface-programmation

def nouveau_stylo(ecriture, fond, largeur):
    '''Renvoie la référence d'un stylo configuré

    :: param ecriture(str)  :: la couleur d'écriture ('red', '#FF0000')
    :: param fond(str)      :: la couleur de fond pour ce stylo
    :: param largeur(int)   :: la largeur du trait
    :: return (Turtle)      :: renvoie un objet de la classe Turtle

    '''
    feutre = trt.Turtle()
    feutre.color(ecriture)
    feutre.fillcolor(fond)
    feutre.pensize(largeur)
    feutre.speed(0)

    return feutre

def deplacer(feutre, x, y):
    '''Lève le feutre, déplace le feutre et abaisse le feutre

    :: param feutre(Turtle)  :: la référence du crayon
    :: param x(int,flt)      :: coordonnée horizontale (abscisse)
    :: param y(int,flt)      :: coordonnée verticale (ordonnée)
    :: return (None)         :: c'est une fonction sans retour
    .. effet de bord         :: modifie l'état de feutre

    '''
    feutre. penup()      # On lève la pointe
    feutre.goto(x, y)    # On déplace le crayon
    feutre.pendown()     # On abaisse la pointe

def trace_arc_de_cercle(feutre, rayon, angle=360):
    '''Trace un arc de cercle à l'aide du crayon feutre
 
    :: param ftr(Turtle)    :: la référence de l'objet Turtle
    :: param rayon(int)     :: la valeur en pixel du rayon
    :: param angle(int)     :: l'angle à tracer (360 pour un cercle)
    :: return (None)        :: fonction sans retour
    .. effet de bord        :: modifie l'état de feutre
 
    '''
    feutre.begin_fill()
    feutre.circle(rayon, angle)
    feutre.end_fill()
    feutre.hideturtle()

def trace_rectangle(feutre, largeur, hauteur):
    '''Trace un rectangle à l'aide du crayon feutre

    :: param feutre(Turtle)  :: la référence du crayon
    :: param largeur(int)    :: la valeur en pixel de la largeur (x)
    :: param hauteur(int)    :: la valeur en pixel de la hauteur (y)
    :: return (None)         :: fonction sans retour
    .. effet de bord         :: modifie l'état de ftr

    '''
    feutre.begin_fill()
    for x in range (2) :
        feutre.forward(largeur)
        feutre.left(90)
        feutre.forward(hauteur)
        feutre.left(90)
    feutre.end_fill()
    feutre.hideturtle()

def trace_triangle_equilateral(feutre, cote) :
    '''Trace un triangle équilatéral à l'aide du crayon feutre

    :: param feutre(Turtle)   :: la référence du crayon
    :: param cote(int)        :: la valeur en pixel du côté
    :: return (None)          :: une fonction sans retour
    .. effet de bord          :: modifie l'état de ftr

    '''
    feutre.begin_fill()
    for x in range(3):
        feutre.forward(cote)
        feutre.left(120)        
    feutre.end_fill()
    feutre.hideturtle()

def trace_triangle_isocele(feutre, cote, hauteur) :
    '''Trace un triangle équilatéral à l'aide du crayon feutre

    :: param feutre(Turtle)   :: la référence du crayon
    :: param cote(int)        :: la valeur en pixel du côté
    :: return (None)          :: une fonction sans retour
    .. effet de bord          :: modifie l'état de ftr

    '''
    x, y = feutre.position()
    feutre.begin_fill()
    feutre.goto(x+cote, y)
    feutre.goto(x+cote//2, y+hauteur)
    feutre.goto(x, y)       
    feutre.end_fill()
    feutre.hideturtle()

    
# Déclarations des fonctions d'interface du module

def rectangle(largeur, hauteur, infos, coordonnees):
    '''Trace un rectangle à partir des infos et aux bonnees coordonnées

    :: param largeur(int)                  :: un nombre representant la largeur (x)
    :: param hauteur(int)                  :: un nombre representant la hauteur (y)
    :: param infos(dict)                   :: un dictionnaire {"écriture":str, "fond":str, "épaisseur":int}
    :: param coordonnees(tuple (int,int) ) :: les coordonnées (x,y)

    '''
    trt.Screen().tracer(0) # juste pour annuler l'animation
    ecriture = infos['écriture']
    fond = infos['fond']
    epaisseur = infos['épaisseur']
    x = coordonnees[0]                  
    y = coordonnees[1]
    feutre = nouveau_stylo(ecriture, fond, epaisseur)
    deplacer(feutre, x, y)
    trace_rectangle(feutre, largeur, hauteur)
    trt.Screen().update() 
    return feutre

def triangle_equilateral(cote, infos, coordonnees):
    '''Trace un triangle equilateral à partir des infos et aux bonnees coordonnées

    :: param cote(int)                     :: la valeur en pixel du côté
    :: param infos(dict)                   :: un dictionnaire {"écriture":str, "fond":str, "épaisseur":int}    
    :: param coordonnees(tuple (int,int) ) :: les coordonnées (x,y)

    '''
    ecriture = infos['écriture']
    fond = infos['fond']
    epaisseur = infos['épaisseur']
    x = coordonnees[0]
    y = coordonnees[1]

    feutre = nouveau_stylo(ecriture, fond, epaisseur)
    deplacer(feutre, x, y)
    trace_triangle_equilateral(feutre, cote)

    return feutre

def triangle_isocele(cote, hauteur, infos, coordonnees):
    '''Trace un triangle isocèle aux bonnees coordonnées

    :: param cote(int)                     :: la valeur en pixel de l'hypoténuse

    :: param infos(dict)                   :: un dictionnaire {"écriture":str, "fond":str, "épaisseur":int}    
    :: param coordonnees(tuple (int,int) ) :: les coordonnées (x,y)

    '''
    ecriture = infos['écriture']
    fond = infos['fond']
    epaisseur = infos['épaisseur']
    x = coordonnees[0]
    y = coordonnees[1]

    feutre = nouveau_stylo(ecriture, fond, epaisseur)
    deplacer(feutre, x, y)
    trace_triangle_isocele(feutre, cote, hauteur)

    return feutre


def cercle(rayon, infos, coordonnees):
    '''Trace un cercle selon un certain rayon et coordonnées

    :: param rayon(int)                     :: le rayon du cercle
    :: param infos(dict)                    :: un dictionnaire{"écriture":str, "fond":str, "épaisseur":int}
    :: param coordonnees(tuple (int,int) )  :: un tuple (x,y)

    '''
    ecriture = infos['écriture']
    fond = infos['fond']
    epaisseur = infos['épaisseur']
    x = coordonnees[0]
    y = coordonnees[1]

    feutre = nouveau_stylo(ecriture, fond, epaisseur)
    deplacer(feutre, x, y)
    trace_arc_de_cercle(feutre, rayon)

    return feutre

def arc_de_cercle(rayon, angle, infos, coordonnees):
    '''Trace un arc de cercle selon un certain rayon et coordonnées

    :: param rayon(int)                     :: le rayon du cercle
    :: param angle(int)                     :: l'angle de cet arc de cercle
    :: param infos(dict)                    :: un dictionnaire{"écriture":str, "fond":str, "épaisseur":int}
    :: param coordonnees(tuple (int,int) )  :: un tuple (x,y)

    '''
    ecriture = infos['écriture']
    fond = infos['fond']
    epaisseur = infos['épaisseur']
    x = coordonnees[0]
    y = coordonnees[1]

    feutre = nouveau_stylo(ecriture, fond, epaisseur)
    deplacer(feutre, x, y)
    trace_arc_de_cercle(feutre, rayon, angle)

    return feutre


# Exemples de fonctionnement

def exemples_formes():
    infos = {'écriture':'blue', 'fond':'#FF88FF', 'épaisseur':5}
    triangle_equilateral(50, infos, (50,100))
    triangle_isocele(50, 30, infos, (150,100))
    cercle(75, infos, (200,-200))
    rectangle(50, 30, infos, (0,0))

if __name__ == '__main__':        
    exemples_formes()
    
