from PIL import Image
SEUIL = 0.5

class Pixel:
    """Une classe représentant un pixel dans une image."""
    
    def __init__(self, im: Image, x: int, y: int):
        """
        Construit un nouveau pixel.

        précondition: l'image est supposée être codée en RGB.
        """
        self._im = im
        self._coords = (x, y)


    def coords(self) -> tuple[int]:
        """Renvoie les coordonnées d'un pixel."""
        return self._coords

    def luminosite(self) -> float:
        """Renvoie la luminosité d'un pixel."""
        return sum(self._im.getpixel(self._coords)) / (3 * 255)

    def est_allume(self, seuil = SEUIL) -> bool:
        """Renvoie True ssi un pixel est allumé."""
        return self.luminosite() < seuil

    def neighboors(self, voisinage) -> list:
        """Renvoie un voisinage."""
        w, h = self._im.size
        x, y = self._coords
        res = []
        for inc in voisinage:
            xinc, yinc = inc
            newx = x + xinc
            newy = y + yinc
            if (newx >= 0) and (newx < xsize) and (newy >= 0) and (newy < ysize):
                res.append ( Pixel(self._im, newx,newy) )
        return res

    def neighboors4(self) -> list:
        """Renvoie les quatre voisins."""
        return self.neighboors(((-1,0), (0,1), (1,0), (0,-1)))

    def neighboors8(self) -> list[tuple]:
        """Renvoie les huit voisins."""
        return self.neighboors([ (-1,-1), (-1,0), (-1,1), (0,1),
                                 (1,1), (1,0), (1,-1), (0,-1) ])
