import sys
import glob
from bande import Bande
from PIL import Image
from algos import *

def charge_bandelettes(prefix: str) -> list[Bande]:
    """
    Charge une série de bandelettes au format png.

    Les noms des fichiers commencent tous par prefix.
    """
    res = list()
    for fname in sorted(glob.glob(prefix + '*.png')):
        im = Image.open(fname)
        im = im.convert('RGB')
        res.append(Bande(im))
    return res

def colle_bandelettes(perm: list[int], bandelettes: list[Bande]):
    """Recolle des bandelettes dans un certain ordre."""
    n = len(bandelettes)
    assert n >= 0, "il faut au moins une bande."
    totalw = sum(b.dimensions()[0]
                 for b in bandelettes)
    totalh = max(b.dimensions()[1]
                 for b in bandelettes)
    res = Image.new('RGB', (totalw, totalh))
    x = 0
    for i in perm:
        w, h = bandelettes[i].dimensions()
        res.paste(bandelettes[i].image(), (x, 0))
        x += w
    return res


def usage():
    """Print usage message."""
    print("Usage: {:s} <prefix des images>".format(sys.arv[0]))
    
if __name__ == '__main__':
    if len(sys.argv) < 1:
        usage()
        exit(1)
    prefix = sys.argv[1]
    bandelettes = charge_bandelettes(prefix)
    # table = construit_table_scores(bandelettes)
    # affiche_matrice(table)
    sols = resoud_bandelettes(bandelettes)
    if len(sols) > 0:
        sol = max(sols, key=lambda s: s[1])[0]
        print(sol)
        im = colle_bandelettes(sol, bandelettes)
        im.show()
        input('appuyer sur entrée')
