#!/usr/bin/python3
# -*- coding: utf-8 -*-

import sys
import os.path

from PIL import Image

import algos

if __name__ == '__main__':
    if (len(sys.argv) != 4 and len(sys.argv) != 5):
        print (
"""Usage: {:s} <image> <nb de tranches> <prefixe des tranches>""".
            format(sys.argv[0]) )
        exit(1)


    image_file = sys.argv[1]
    nb_slices = int(sys.argv[2])
    prefix = sys.argv[3]
    if len(sys.argv) > 4:
        fixed = sys.argv[4] == 'false'
    else:
        fixed = False
    
    print( ( "\
    Image:             %s\n\
    Nb de tranches:    %d\n\
    Prefixe de sortie :%s" % \
             (image_file, nb_slices, prefix) ) )
    
    im = Image.open(image_file)

    if fixed:
        algos.broyage(im, nb_slices, prefix, [9,5,7,2,0,8,1,4,6,3])
    else:
        algos.broyage(im, nb_slices, prefix)
    

