from PIL.Image import Image
from pixel import Pixel

class Bande:
    """Une classe représentant une bandelette."""
    
    def __init__(self, im: Image):
        """Construit une nouvelle bandelette."""
        self._im = im

    def dimensions(self) -> tuple[int]:
        """Renvoie les dimensions de l'image."""
        return self._im.size

    def image(self) -> Image:
        """Renvoie l'image de la bande."""
        return self._im

    def scoreParPixel(self, other) -> float:
        """
        Calcule un score en examinant les pixels adjacents.

        précondition: les deux bandelettes ont la même longueur.
        """
        w, h = self.dimensions()
        wo, ho = other.dimensions()
        assert h == ho, "les bandelettes n'ont pas la même longueur."
        nbre_commun, nbre_droit, nbre_gauche = 0, 0, 0
        for y in range(h):
            pixel_gauche = Pixel(self._im, w-1, y)
            pixel_droit = Pixel(other._im, 0, y)
            if pixel_gauche.est_allume():
                if pixel_droit.est_allume():
                    nbre_commun += 1
                else:
                    nbre_gauche += 1
            elif pixel_droit.est_allume():
                nbre_droit += 1
        return nbre_commun / (nbre_droit + nbre_gauche + 1)
