import random
from bande import Bande
from PIL import Image

MIN_SCORE = 0.2

def construit_table_scores(bandelettes: list[Bande]) -> list:
    """Construit la table des scores."""
    n = len(bandelettes)
    res = [ [ 0.0 for j in range(n) ]
            for i in range(n) ]
    for i in range(n):
        for j in range(n):
            if i != j:
                res[i][j] = bandelettes[i].scoreParPixel(bandelettes[j])
    return res


def affiche_matrice(mat):
    """Affiche une matrice."""
    for i in range(len(mat)):
        for j in range(len(mat[i])):
            print("{:.2f} ".format(mat[i][j]), end='')
        print()


def broyage(im: Image, nb: int, prefix: str, perm = None):
    """Broie une image."""
    w, h = im.size
    assert (nb < w), \
    "Le nombre de tranches doit être inférieur à la taille horizontale"

    if perm is None:
        perm = [ i for i in range(0,nb) ]
        random.shuffle(perm)

    for i in range(0, nb):
        x1 = (i * w) // nb
        x2 = ( (i + 1) * w) // nb 

        sub_im = im.crop( (x1, 0, x2, h) )
        sub_im.save( prefix + f"-{perm[i]}.png" )

def resoud_bandelettes(bandelettes: list[Bande], min_score = MIN_SCORE) -> list:
    """
    Renvoie une liste de couples (permutation, score).

    Les permutations sont des séquences d'entiers qui permettent
    de retrouver l'image d'origine.
    """
    n = len(bandelettes)
    scores = construit_table_scores(bandelettes)
    todo = [ ([i], 0.0) for i in range(n) ]
    res = []
    while len(todo) > 0:
        perm, score = todo.pop()
        if len(perm) == n:
            res.append( (perm, score) )
        else:
            dernier = perm[-1]
            for j in range(n):
                if j not in perm:
                    sc = scores[dernier][j]
                    print(f"{dernier} -> {j} : {sc}")
                    if sc >= min_score:
                        todo.append((perm + [j], score + sc ))
    return res
