import sys
import glob
from manim import *
sys.path.append('../src')
from algos import *
from debroyeur import *

PREFIX = '../images/shred-complainte'

class Glouton(Scene):
    """Algorithme glouton présenté."""

    def load_images(self):
        """Load the slices image ."""
        bandelettes = []
        for fname in sorted(glob.glob(PREFIX + '*.png')):
            b = ImageMobject(fname)
            bandelettes.append(b)
        self.g = Group(*bandelettes).scale(.65).arrange(RIGHT).to_corner(LEFT + UP)
        self.add(self.g)
        self.play(ShowIncreasingSubsets(self.g, run_time=3))

    def build_matrix(self):
        scores = construit_table_scores(charge_bandelettes(PREFIX))
        m = DecimalMatrix(scores,
                          element_to_mobject_config={"num_decimal_places": 2})
        m.scale(.45).next_to(self.g, RIGHT)
        self.add(m)
        self.play(FadeIn(m))
        self.m = m


    def solve(self):
        r = SurroundingRectangle(self.m.get_columns()[9])
        self.add(r)
        self.play(FadeIn(r))
        self.play(self.g[9].animate.to_corner(LEFT + DOWN))
        self.play(FadeOut(r))
        perm = (9, 5, 7, 2, 0, 8, 1, 4, 6, 3)
        for i in range(len(perm) - 1):
            row = self.m.get_rows()[perm[i]]
            r = SurroundingRectangle(row)
            self.add(r)
            self.play(FadeIn(r))
            self.play(Indicate(row[perm[i+1]]))
            self.play(self.g[perm[i+1]].animate.next_to(self.g[perm[i]]))
            self.play(FadeOut(r))
        anim_colle = [ self.g[perm[i+1]].animate.next_to(self.g[perm[i]], buff=0)
                       for i in range(len(perm) -1 )]
        self.play(*anim_colle)
            
    
    def construct(self):
        """Build the animation."""
        self.load_images()
        self.wait()
        self.build_matrix()
        self.wait()
        self.solve()
        self.wait()
